/*--------------------------------------------------------------------------*/
// Example code by Miz (CodeRage@bigfoot.com)
// Windoze 'Process Patcher' For Beginners ;)
// LSG-Ware - If you like/use please listen to the genius of Oliver Lieb ;)
/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
#define	WIN32_LEAN_AND_MEAN			//	Eliminate some unnecessary headers
/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
#include	<windows.h>
#include	<windowsx.h>
#include	<stdlib.H>
#include	"resource.h"
#include	"commctrl.h"
#include	"commdlg.h"
#include	"stdio.h"
#include	"commctrl.h"
#include	"commdlg.h"
#include	"io.h"
#include	"string.h"

#include	"Inc\File.h"
/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
typedef struct s_PatchDef
{
	char			*Address;
	unsigned int  	Count;
	unsigned char	Data[];
}t_PatchDef;
/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
extern HINSTANCE	MainInstance;
STARTUPINFO			StartupInfo;
PROCESS_INFORMATION	ProcessInfo;
/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
char	MyTitle[128];
char	WindowName[] = {"Delta Force "};
char	ClassName[]  = {"NLGAMECLASS"};

// Infinite Ammo, All Weapons
t_PatchDef		Opt1a_Off  = {(char *)0x00449FD0,  6, {0x29,0xb0,0xd4,0x33,0x93,0x00}};
t_PatchDef		Opt1a_On   = {(char *)0x00449FD0,  6, {0x90,0x90,0x90,0x90,0x90,0x90}};
t_PatchDef		Opt1b_Off  = {(char *)0x0044A362,  6, {0x29,0x88,0x54,0x34,0x93,0x00}};
t_PatchDef		Opt1b_On   = {(char *)0x0044A362,  6, {0x90,0x90,0x90,0x90,0x90,0x90}};

// Rapid Fire, All Weapons (60 Rockets/sec!)
t_PatchDef		Opt2a_Off  = {(char *)0x00449862,  3, {0x8d,0x6f,0xff}};
t_PatchDef		Opt2a_On   = {(char *)0x00449862,  3, {0x33,0xed,0x90}};

// Weapons Have 8x Scopes
t_PatchDef		Opt3a_Off  = {(char *)0x0044B46C,  6, {0x8b,0x15,0xd4,0x34,0x93,0x00}};
t_PatchDef		Opt3a_On   = {(char *)0x0044B46C,  6, {0xb8,0x08,0x00,0x00,0x00,0xc3}};

// Weapons Have 16x Scopes
t_PatchDef		Opt4a_Off  = {(char *)0x0044B46C,  6, {0x8b,0x15,0xd4,0x34,0x93,0x00}};
t_PatchDef		Opt4a_On   = {(char *)0x0044B46C,  6, {0xb8,0x10,0x00,0x00,0x00,0xc3}};

// Show Players/Teams In MultiPlayer
t_PatchDef		Opt5a_Off  = {(char *)0x0043D43F,  6, {0x0f,0x85,0x5f,0x04,0x00,0x00}};
t_PatchDef		Opt5a_On   = {(char *)0x0043D43F,  6, {0x90,0x90,0x90,0x90,0x90,0x90}};
/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
void	CheckKeys(HWND hDlg);
int		InGamePatch(t_PatchDef *PatchOn, t_PatchDef *PatchOff);
int		MemCmp(char *Buf1, char *Buf2, int NumbChars);
/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
BOOL CALLBACK	MainDialogCallback(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch (uMsg)
	{
		case WM_INITDIALOG:
			SetWindowText(hDlg, &MyTitle[0]);
			SetTimer(hDlg, 1, 200, NULL);
			return 1;

		case WM_CLOSE:
			EndDialog(hDlg, 0);
			break;

		case WM_TIMER:
			CheckKeys(hDlg);
			break;

		case IDCANCEL:
			EndDialog(hDlg, 0);
			break;

		case WM_COMMAND:
			switch (LOWORD(wParam))
			{
				case IDLAUNCH:
					EndDialog(hDlg, 0);
					break;
			}
			return(1);
	}
	return(0);
}
/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
void	CheckKeys(HWND hDlg)
{
	//Infinite Ammo
	if (GetAsyncKeyState(VK_NUMPAD1))
	{
		if (InGamePatch(&Opt1a_On, &Opt1a_Off) && InGamePatch(&Opt1b_On, &Opt1b_Off))
			MessageBeep(-1);
	}

	//Rapid Fire
	if (GetAsyncKeyState(VK_NUMPAD2))
	{
		if (InGamePatch(&Opt2a_On, &Opt2a_Off))
			MessageBeep(-1);
	}

	//Weapons Have 8x Scopes
	if (GetAsyncKeyState(VK_NUMPAD3))
	{
		if (InGamePatch(&Opt3a_On, &Opt3a_Off))
			MessageBeep(-1);
		else
		{
			if (InGamePatch(&Opt3a_On, &Opt4a_On))
				MessageBeep(-1);
		}
	}

	//Weapons Have 16x Scopes
	if (GetAsyncKeyState(VK_NUMPAD4))
	{
		if (InGamePatch(&Opt4a_On, &Opt4a_Off))
			MessageBeep(-1);
		else
		{
			if (InGamePatch(&Opt4a_On, &Opt3a_On))
				MessageBeep(-1);
		}
	}

	//Show All Players By Team In MultiPlayer
	if (GetAsyncKeyState(VK_NUMPAD5))
	{
		if (InGamePatch(&Opt5a_On, &Opt5a_Off))
			MessageBeep(-1);
	}
}
/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
int InGamePatch(t_PatchDef *PatchOn, t_PatchDef *PatchOff)
{
HWND			GameWindowHandle;
DWORD			ProcessId;
DWORD			ThreadId;
HANDLE			ProcessHandle;
unsigned char	TempBuffer[256];
DWORD			BytesRead;
DWORD			BytesWritten;
int				ReturnVal;

	ReturnVal = FALSE;

//	GameWindowHandle = FindWindow(&ClassName[0], &WindowName[0]);
	GameWindowHandle = FindWindow(&ClassName[0], NULL);
	if (GameWindowHandle)
	{
		ThreadId = GetWindowThreadProcessId(GameWindowHandle, &ProcessId);
		if (ThreadId)
		{
			ProcessHandle = OpenProcess(PROCESS_ALL_ACCESS, FALSE, ProcessId);
			if (ProcessHandle)
			{
				ReadProcessMemory(ProcessHandle, PatchOn->Address, &TempBuffer[0], PatchOn->Count, &BytesRead);

				if (MemCmp(&TempBuffer[0], &PatchOn->Data[0], PatchOn->Count))
				{
					WriteProcessMemory(ProcessHandle, PatchOff->Address, &PatchOff->Data[0], PatchOff->Count, &BytesWritten);
					ReturnVal = TRUE;
				}
				else
				{
					if (MemCmp(&TempBuffer[0], &PatchOff->Data[0], PatchOff->Count))
					{
						WriteProcessMemory(ProcessHandle, PatchOn->Address, &PatchOn->Data[0], PatchOn->Count, &BytesWritten);
						ReturnVal = TRUE;
					}
				}
				CloseHandle(ProcessHandle);
			}
		}
	}
	return(ReturnVal);
}
/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
int	MemCmp(char *Buf1, char *Buf2, int NumbChars)
{
int	i;

	for (i=0; (Buf1[i] == Buf2[i]) && (i<NumbChars); i++);
	if  (i==NumbChars)
		return(TRUE);
	else
		return(FALSE);
}
/*--------------------------------------------------------------------------*/

